/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.common;

import com.ibm.hsc.cim.client.pi.PIHSCProfileCIMClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PILPARProfileDataBean;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.hsc.rep.client.RClientObject;
import com.ibm.hsc.websm.common.LparUtils;
import com.ibm.hsc.websm.common.WSMCommonUtil;
import com.ibm.websm.diagnostics.IDebug;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class ProfileAttributes {
    public static final String HSC_COMPUTER_SYSTEM = "IBMHSC_ComputerSystem";
    public static final String HSC_DEFAULT_PROFILE = "IBMHSC_DefaultLparProfile";
    public static final String HSC_PARTITION = "IBMHSC_Partition";
    public static final String HSC_LPAR_PROFILE = "IBMHSC_LparProfile";
    public static final String PARTITION_PROFILE_ASSOC = "IBMHSC_PartitionProfile";
    public static final String DEFAULT_PROFILE_ASSOC = "IBMHSC_DefaultLparProfile";
    public static final String KEY = "Name";
    public static final String NAME = "name";
    public static final String BOOTMODE_PROP = "bootMode_PROP";
    public static final String CIM_OBJECT_PATH_PROP = "cimObjectPath_PROP";
    public static final String DESIRED_CPU_COUNT_PROP = "desired_procs";
    public static final String DESIRED_MEMORY_MB_PROP = "desired_mem";
    public static final String MAXIMUM_CPU_COUNT_PROP = "max_procs";
    public static final String MAXIMUM_MEMORY_MB_PROP = "max_mem";
    public static final String MINIMUM_CPU_COUNT_PROP = "min_procs";
    public static final String MINIMUM_MEMORY_MB_PROP = "min_mem";
    public static final String IODRAWER_PROP = "ioDrawer";
    public static final String IOSLOTS_PROP = "io_slots";
    public static final String IS_DEFAULT_PROFILE_PROP = "isDefaultProfile_PROP";
    public static final String OP_PANEL_VALUE_PROP = "opPanelValue_PROP";
    public static final String RAW_BOOTMODE_PROP = "rawBootMode";
    public static final String RMO_SIZE_PROP = "rmoSize";
    public static final String SERVICE_AUTHORITY_PROP = "service_authority";
    public static final String SETTING_ID = "SettingID";
    public static final String STATE_PROP = "state_PROP";
    private static final String DEBUG_STRING = "%%%%%%%%%%%%%%%%%%%%%";
    public static final String[] ALL_KEYS = new String[]{"Name", "name", "desired_procs", "min_procs", "max_procs", "desired_mem", "min_mem", "max_mem", "ioDrawer", "io_slots", "bootMode_PROP", "isDefaultProfile_PROP", "service_authority", "cimObjectPath_PROP", "state_PROP", "opPanelValue_PROP", "rawBootMode", "virtual_smc_adapters"};
    public static Hashtable BOOT_MODE_MAP;
    public static Vector KEY_LIST;
    private static final String LEGACY = "root/ibmhscV3_2";
    private static final String SQUADRONS = "root/ibmhscS1_0";
    private static final String DB_STRING = "@@@@@@@@ ProfileAttributes @@@@@@@@";
    private PILPARProfileDataBean _profileBean = null;
    private Hashtable _profileProps = new Hashtable(0);
    private String _nameSpace = null;
    private String _profileKey = null;
    private String _profileId = null;
    private String _lparName = null;
    private String _lparKey = null;
    private String _lparId = null;
    private String _hostName = null;
    private Vector _parsedKey = null;
    private String _cecName = null;

    public ProfileAttributes(PILPARProfileDataBean pILPARProfileDataBean) {
        this._nameSpace = SQUADRONS;
        this._profileBean = pILPARProfileDataBean;
    }

    public ProfileAttributes(String string, String string2, String string3) throws PIHscClientException {
        this._parsedKey = WSMCommonUtil.parseProfileKey(string);
        this._nameSpace = string2;
        this._hostName = string3;
        this._profileKey = string;
        this._lparName = (String)this._parsedKey.elementAt(0);
        this._lparId = (String)this._parsedKey.elementAt(1);
        this._cecName = (String)this._parsedKey.elementAt(2);
        this._profileId = (String)this._parsedKey.elementAt(3);
        if (IDebug.enabled()) {
            System.err.println("@@@@@@@@ ProfileAttributes @@@@@@@@ _hostName : " + string3 + " _profileKey : " + this._profileKey + " _lparName : " + this._lparName + " _lparKey : " + this._lparKey + " _profileId : " + this._profileId + " _nameSpace : " + this._nameSpace);
        }
    }

    public ProfileAttributes(String string, String string2) throws PIHscClientException {
        this._parsedKey = WSMCommonUtil.parseProfileKey(string);
        this._hostName = string2;
        this._profileKey = string;
        this._lparName = (String)this._parsedKey.elementAt(0);
        this._lparId = (String)this._parsedKey.elementAt(1);
        this._cecName = (String)this._parsedKey.elementAt(2);
        this._profileId = (String)this._parsedKey.elementAt(3);
        this._lparKey = this._lparName + "~" + HSC_PARTITION + "~";
        this._nameSpace = WSMCommonUtil.getLparNameSpace(this._lparKey);
        if (IDebug.enabled()) {
            System.err.println("@@@@@@@@ ProfileAttributes @@@@@@@@ _hostName : " + string2 + " _profileKey : " + this._profileKey + " _lparName : " + this._lparName + " _lparKey : " + this._lparKey + " _profileId : " + this._profileId + " _nameSpace : " + this._nameSpace);
        }
        if (this._nameSpace == null) {
            String[] stringArray = new String[]{this._lparKey};
            System.err.println("@@@@@@@@ ProfileAttributes @@@@@@@@ nameSpace is null in constructor!!!");
            throw new PIHscClientException("1970", "PIHscClienBundle", "1970", stringArray, null);
        }
    }

    public Hashtable getAttributes(String[] stringArray) throws PIHscClientException {
        PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(this._hostName, this._nameSpace);
        if (stringArray == null || stringArray.length == 0) {
            stringArray = PILPARProfileDataBean.ALL_KEYS;
        }
        try {
            PIHSCProfileCIMClient pIHSCProfileCIMClient = pIHSCClientObjectFactory.createProfileClient(this._cecName, this._lparId, this._profileId, true, true);
            if (pIHSCProfileCIMClient != null) {
                this._profileBean = pIHSCProfileCIMClient.getLPARProfileDataBean(stringArray, true);
                this._profileProps = this.getBeanInfo(stringArray);
                this._profileProps.put("nameSpace_Prop", this._nameSpace);
                this._profileProps.put(KEY, this._profileKey);
                return this._profileProps;
            }
        }
        catch (PIHscClientException pIHscClientException) {
            System.err.println("@@@@@@@@ ProfileAttributes @@@@@@@@getAttributes().....");
            pIHscClientException.printStackTrace();
            throw pIHscClientException;
        }
        return this._profileProps;
    }

    public Boolean isDefaultProfile() {
        return ProfileAttributes.isDefaultProfile(this._hostName, this._profileId, this._lparName);
    }

    public static Boolean isDefaultProfile(String string, String string2, String string3) {
        Enumeration enumeration;
        block3: {
            enumeration = null;
            CIMObjectPath cIMObjectPath = null;
            try {
                cIMObjectPath = new CIMObjectPath(HSC_LPAR_PROFILE);
                cIMObjectPath.addKey(SETTING_ID, new CIMValue((Object)string2));
                cIMObjectPath.addKey("PartitionName", new CIMValue((Object)string3));
                cIMObjectPath.addKey("PartitionCreationClassName", new CIMValue((Object)HSC_PARTITION));
                cIMObjectPath.setNameSpace(SQUADRONS);
                enumeration = PIHscUtil.getCIMAssociation(string, cIMObjectPath, "IBMHSC_DefaultLparProfile", HSC_PARTITION, null, null);
            }
            catch (Throwable throwable) {
                if (!IDebug.enabled) break block3;
                System.err.println("isDefaultProfile cop: " + cIMObjectPath);
                throwable.printStackTrace(System.err);
            }
        }
        if (enumeration != null && enumeration.hasMoreElements()) {
            return new Boolean(true);
        }
        return new Boolean(false);
    }

    public PILPARProfileDataBean getDataBean() {
        return this._profileBean;
    }

    private Hashtable getProfileAttribute(String[] stringArray, String string, String string2) throws CIMException {
        Object object;
        Object object2;
        CIMInstance cIMInstance;
        CIMObjectPath cIMObjectPath = null;
        cIMObjectPath = new CIMObjectPath(HSC_LPAR_PROFILE);
        Vector vector = PIHscUtil.decodeKey(string2);
        if (KEY_LIST != null) {
            cIMInstance = vector.elements();
            object2 = KEY_LIST.elements();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                cIMObjectPath.addKey((String)object, new CIMValue((Object)((String)cIMInstance.nextElement())));
            }
        }
        if ((cIMInstance = PIHscUtil.getCIMInstance(string, cIMObjectPath, false)) != null) {
            object2 = this.getAttributeValues(cIMInstance);
            object = null;
            if (object2 != null && stringArray != null) {
                object = new Hashtable();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i];
                    ((Hashtable)object).put(string3, ((Hashtable)object2).get(string3));
                }
                return object;
            }
            return object2;
        }
        return null;
    }

    public static Hashtable mapRObjectToMObject(RClientObject rClientObject, String string, String string2) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String string3 = "";
        String string4 = "";
        Hashtable hashtable2 = rClientObject.getAllProperties();
        hashtable.put(KEY, string);
        hashtable.put("nameSpace_Prop", SQUADRONS);
        Object object = hashtable2.get("PartitionName");
        if (null != object) {
            string4 = (String)object;
            hashtable.put("lpar_id", string4.substring(0, string4.indexOf("*")));
        }
        if (null != (object = hashtable2.get(SETTING_ID))) {
            string3 = (String)object;
            hashtable.put(SETTING_ID, string3);
        }
        hashtable.put(IS_DEFAULT_PROFILE_PROP, ProfileAttributes.isDefaultProfile(string2, string3, string4));
        object = hashtable2.get("UserDefinedName");
        if (null != object) {
            hashtable.put(NAME, object);
        }
        if (null != (object = hashtable2.get("DesiredCPUCount"))) {
            if (object instanceof UnsignedInt16) {
                object = new Integer(((UnsignedInt16)object).intValue());
            }
            hashtable.put(DESIRED_CPU_COUNT_PROP, object);
        }
        if (null != (object = hashtable2.get("MinimumCPUCount"))) {
            if (object instanceof UnsignedInt16) {
                object = new Integer(((UnsignedInt16)object).intValue());
            }
            hashtable.put(MINIMUM_CPU_COUNT_PROP, object);
        }
        if (null != (object = hashtable2.get("MaximumCPUCount"))) {
            if (object instanceof UnsignedInt16) {
                object = new Integer(((UnsignedInt16)object).intValue());
            }
            hashtable.put(MAXIMUM_CPU_COUNT_PROP, object);
        }
        if (null != (object = hashtable2.get("MinProcUnit"))) {
            if (object instanceof UnsignedInt32) {
                object = new Long(((UnsignedInt32)object).longValue());
            }
            hashtable.put("min_proc_units", object);
        }
        if (null != (object = hashtable2.get("DesiredProcUnit"))) {
            if (object instanceof UnsignedInt32) {
                object = new Long(((UnsignedInt32)object).longValue());
            }
            hashtable.put("desired_proc_units", object);
        }
        if (null != (object = hashtable2.get("MaxProcUnit"))) {
            if (object instanceof UnsignedInt32) {
                object = new Long(((UnsignedInt32)object).longValue());
            }
            hashtable.put("max_proc_units", object);
        }
        if (null != (object = hashtable2.get("DesiredMemory"))) {
            if (object instanceof UnsignedInt32) {
                object = new Long(((UnsignedInt32)object).longValue());
            }
            hashtable.put(DESIRED_MEMORY_MB_PROP, object);
        }
        if (null != (object = hashtable2.get("MinimumMemory"))) {
            if (object instanceof UnsignedInt32) {
                object = new Long(((UnsignedInt32)object).longValue());
            }
            hashtable.put(MINIMUM_MEMORY_MB_PROP, object);
        }
        if (null != (object = hashtable2.get("MaximumMemory"))) {
            if (object instanceof UnsignedInt32) {
                object = new Long(((UnsignedInt32)object).longValue());
            }
            hashtable.put(MAXIMUM_MEMORY_MB_PROP, object);
        }
        if (null != (object = hashtable2.get("ProcMode"))) {
            if (object instanceof UnsignedInt8) {
                object = new Short(((UnsignedInt8)object).shortValue());
            }
            hashtable.put("proc_mode", object);
        }
        if (null != (object = hashtable2.get("SharingMode"))) {
            if (object instanceof UnsignedInt8) {
                object = new Short(((UnsignedInt8)object).shortValue());
            }
            hashtable.put("sharing_mode", object);
        }
        if (null != (object = hashtable2.get("SharingMode"))) {
            if (object instanceof UnsignedInt8) {
                object = new Integer(((UnsignedInt8)object).shortValue());
            }
            hashtable.put("uncap_weight", object);
        }
        if (null != (object = hashtable2.get("LoadSourceDRCIndex"))) {
            if (object instanceof UnsignedInt32) {
                object = new Long(((UnsignedInt32)object).longValue());
            }
            hashtable.put("load_source_slot", object);
        }
        if (null != (object = hashtable2.get("AltLoadSourceDRCIndex"))) {
            if (object instanceof UnsignedInt32) {
                object = new Long(((UnsignedInt32)object).longValue());
            }
            hashtable.put("alt_restart_device_slot", object);
        }
        if (null != (object = hashtable2.get("ConsoleDRCIndex"))) {
            if (object instanceof UnsignedInt32) {
                object = new Long(((UnsignedInt32)object).longValue());
            }
            hashtable.put("console_slot", object);
        }
        if (null != (object = hashtable2.get("AltConsoleDRCIndex"))) {
            if (object instanceof UnsignedInt32) {
                object = new Long(((UnsignedInt32)object).longValue());
            }
            hashtable.put("alt_console_slot", object);
        }
        if (null != (object = hashtable2.get("ECSDRCIndex"))) {
            if (object instanceof UnsignedInt32) {
                object = new Long(((UnsignedInt32)object).longValue());
            }
            hashtable.put("op_console_slot", object);
        }
        if (null != (object = hashtable2.get("ECSDRCIndex"))) {
            hashtable.put(IOSLOTS_PROP, object);
        }
        if (null != (object = hashtable2.get("BootMode"))) {
            if (object instanceof UnsignedInt8) {
                object = new Short(((UnsignedInt8)object).shortValue());
            }
            hashtable.put(BOOTMODE_PROP, object);
        }
        if (null != (object = hashtable2.get("SFPSurveillance"))) {
            if (object instanceof UnsignedInt8) {
                object = new Short(((UnsignedInt8)object).shortValue());
            }
            hashtable.put("conn_monitoring", object);
        }
        if (null != (object = hashtable2.get("AutoIPLEnabled"))) {
            if (object instanceof UnsignedInt8) {
                object = new Short(((UnsignedInt8)object).shortValue());
            }
            hashtable.put("auto_start", object);
        }
        if (null != (object = hashtable2.get("HostingPartitions"))) {
            hashtable.put("power_ctrl_lpar_ids", object);
        }
        if (null != (object = hashtable2.get("VirtualOptiConnectPool"))) {
            if (object instanceof UnsignedInt8) {
                object = new Short(((UnsignedInt8)object).shortValue());
            }
            hashtable.put("virtual_opti_pool_id", object);
        }
        if (null != (object = hashtable2.get("HSLOptiConnectPool"))) {
            if (object instanceof UnsignedInt8) {
                object = new Short(((UnsignedInt8)object).shortValue());
            }
            hashtable.put("hsl_pool_id", object);
        }
        if (null != (object = hashtable2.get("MinInteractivePerf"))) {
            if (object instanceof UnsignedInt16) {
                object = new Integer(((UnsignedInt16)object).intValue());
            }
            hashtable.put("min_5250_cpw_percent", object);
        }
        if (null != (object = hashtable2.get("DesiredInteractivePerf"))) {
            if (object instanceof UnsignedInt16) {
                object = new Integer(((UnsignedInt16)object).intValue());
            }
            hashtable.put("desired_5250_cpw_percent", object);
        }
        if (null != (object = hashtable2.get("MaxInteractivePerf"))) {
            if (object instanceof UnsignedInt16) {
                object = new Integer(((UnsignedInt16)object).intValue());
            }
            hashtable.put("max_5250_cpw_percent", object);
        }
        if (null != (object = hashtable2.get("SNIConfigMode"))) {
            if (object instanceof UnsignedInt8) {
                object = new Short(((UnsignedInt8)object).shortValue());
            }
            hashtable.put("sni_config_mode", object);
        }
        if (null != (object = hashtable2.get("SNIDeviceID"))) {
            hashtable.put("sni_device_ids", object);
        }
        if (null != (object = hashtable2.get("SNIWindows"))) {
            hashtable.put("sni_windows", object);
        }
        if (IDebug.enabled) {
            System.err.println("%%%%%%%%%%%%%%%%%%%%%  Profile Attributes");
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                System.err.println("key: " + k + "  val: " + hashtable.get(k).toString());
            }
            System.err.println(DEBUG_STRING);
        }
        return hashtable;
    }

    public static Hashtable getAttributes(Hashtable hashtable, String[] stringArray) {
        Object v;
        Hashtable hashtable2 = new Hashtable();
        if (null == stringArray) {
            stringArray = ALL_KEYS;
        }
        HashSet<String> hashSet = new HashSet<String>(stringArray.length * 2);
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        if (hashSet.contains(NAME) && null != (v = hashtable.get("UserDefinedName"))) {
            hashtable2.put(NAME, v);
        }
        if (IDebug.enabled) {
            System.err.println("%%%%%%%%%%%%%%%%%%%%%  Profile Attributes");
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                System.err.println("key: " + k + "  val: " + hashtable2.get(k).toString());
            }
            System.err.println(DEBUG_STRING);
        }
        return hashtable2;
    }

    private Hashtable getAttributeValues(CIMInstance cIMInstance) {
        short s;
        String string;
        Hashtable hashtable = ProfileAttributes._initAttrValues();
        CIMObjectPath cIMObjectPath = PIHscUtil.constructPath(cIMInstance);
        hashtable.put(CIM_OBJECT_PATH_PROP, cIMObjectPath);
        hashtable.put(KEY, LparUtils.getProfileKey(cIMObjectPath));
        CIMProperty cIMProperty = cIMInstance.getProperty("UserDefinedName");
        CIMValue cIMValue = null;
        if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
            hashtable.put(NAME, cIMValue.getValue());
        }
        if ((cIMProperty = cIMInstance.getProperty("BootMode")) != null && (cIMValue = cIMProperty.getValue()) != null && (string = (String)BOOT_MODE_MAP.get(Short.toString(s = ((Number)cIMValue.getValue()).shortValue()))) != null) {
            hashtable.put(BOOTMODE_PROP, string);
            hashtable.put(RAW_BOOTMODE_PROP, new Short(s));
        }
        return hashtable;
    }

    private static Hashtable _initAttrValues() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put(KEY, "");
        hashtable.put(NAME, "");
        hashtable.put(CIM_OBJECT_PATH_PROP, new CIMObjectPath(HSC_COMPUTER_SYSTEM));
        hashtable.put(DESIRED_CPU_COUNT_PROP, new Short(0));
        hashtable.put(MINIMUM_CPU_COUNT_PROP, new Short(0));
        hashtable.put(DESIRED_MEMORY_MB_PROP, new Long(0L));
        hashtable.put(MINIMUM_MEMORY_MB_PROP, new Long(0L));
        hashtable.put(BOOTMODE_PROP, "");
        hashtable.put(IS_DEFAULT_PROFILE_PROP, new Boolean(false));
        hashtable.put(RAW_BOOTMODE_PROP, new Short(0));
        hashtable.put(STATE_PROP, "");
        hashtable.put(OP_PANEL_VALUE_PROP, "");
        hashtable.put(SERVICE_AUTHORITY_PROP, new Short(0));
        return hashtable;
    }

    public Hashtable getBeanInfo(String[] stringArray) {
        String[] stringArray2;
        UnsignedInt16[] unsignedInt16Array;
        UnsignedInt8 unsignedInt8;
        UnsignedInt32 unsignedInt32;
        UnsignedInt16 unsignedInt16;
        Boolean bl;
        String string;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(0);
        Map map = null;
        if (this._profileBean == null) {
            return hashtable;
        }
        HashSet<String> hashSet = new HashSet<String>(stringArray.length * 2);
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        if (hashSet.contains("lpar_id") && (string = this._profileBean.getLparId()) != null) {
            hashtable.put("lpar_id", string);
        }
        if (hashSet.contains(IS_DEFAULT_PROFILE_PROP) && (bl = this._profileBean.isDefaultProfile()) != null) {
            hashtable.put(IS_DEFAULT_PROFILE_PROP, bl);
        }
        if (hashSet.contains(NAME) && (string = this._profileBean.getName()) != null) {
            hashtable.put(NAME, string);
        }
        if (hashSet.contains(DESIRED_CPU_COUNT_PROP) && (unsignedInt16 = this._profileBean.getDesiredCpu()) != null) {
            hashtable.put(DESIRED_CPU_COUNT_PROP, new Integer(unsignedInt16.intValue()));
        }
        if (hashSet.contains(MINIMUM_CPU_COUNT_PROP) && (unsignedInt16 = this._profileBean.getMinCpu()) != null) {
            hashtable.put(MINIMUM_CPU_COUNT_PROP, new Integer(unsignedInt16.intValue()));
        }
        if (hashSet.contains(MAXIMUM_CPU_COUNT_PROP) && (unsignedInt16 = this._profileBean.getMaxCpu()) != null) {
            hashtable.put(MAXIMUM_CPU_COUNT_PROP, new Integer(unsignedInt16.intValue()));
        }
        if (hashSet.contains(DESIRED_MEMORY_MB_PROP) && (unsignedInt32 = this._profileBean.getDesiredMem()) != null) {
            hashtable.put(DESIRED_MEMORY_MB_PROP, new Long(unsignedInt32.longValue()));
        }
        if (hashSet.contains(MINIMUM_MEMORY_MB_PROP) && (unsignedInt32 = this._profileBean.getMinMem()) != null) {
            hashtable.put(MINIMUM_MEMORY_MB_PROP, new Long(unsignedInt32.longValue()));
        }
        if (hashSet.contains(MAXIMUM_MEMORY_MB_PROP) && (unsignedInt32 = this._profileBean.getMaxMem()) != null) {
            hashtable.put(MAXIMUM_MEMORY_MB_PROP, new Long(unsignedInt32.longValue()));
        }
        if (hashSet.contains("proc_mode") && (unsignedInt8 = this._profileBean.getProcType()) != null) {
            hashtable.put("proc_mode", new Short(unsignedInt8.shortValue()));
        }
        if (hashSet.contains("sharing_mode") && (unsignedInt8 = this._profileBean.getSharingMode()) != null) {
            hashtable.put("sharing_mode", new Short(unsignedInt8.shortValue()));
        }
        if (hashSet.contains("uncap_weight") && (unsignedInt8 = this._profileBean.getUncappedWeight()) != null) {
            hashtable.put("uncap_weight", new Integer(unsignedInt8.shortValue()));
        }
        if (hashSet.contains("load_source_slot") && (unsignedInt32 = this._profileBean.getLsDrcIndex()) != null) {
            hashtable.put("load_source_slot", new Long(unsignedInt32.longValue()));
        }
        if (hashSet.contains("alt_restart_device_slot") && (unsignedInt32 = this._profileBean.getAltLsDrcIndex()) != null) {
            hashtable.put("alt_restart_device_slot", new Long(unsignedInt32.longValue()));
        }
        if (hashSet.contains("console_slot") && (unsignedInt32 = this._profileBean.getConsoleDrcIndex()) != null) {
            hashtable.put("console_slot", new Long(unsignedInt32.longValue()));
        }
        if (hashSet.contains("alt_console_slot") && (unsignedInt32 = this._profileBean.getAltConsoleDrcIndex()) != null) {
            hashtable.put("alt_console_slot", new Long(unsignedInt32.longValue()));
        }
        if (hashSet.contains("op_console_slot") && (unsignedInt32 = this._profileBean.getEcsDrcIndex()) != null) {
            hashtable.put("op_console_slot", new Long(unsignedInt32.longValue()));
        }
        if (hashSet.contains("min_proc_units") && (unsignedInt32 = this._profileBean.getMinProcUnit()) != null) {
            hashtable.put("min_proc_units", new Long(unsignedInt32.longValue()));
        }
        if (hashSet.contains("desired_proc_units") && (unsignedInt32 = this._profileBean.getDesiredProcUnit()) != null) {
            hashtable.put("desired_proc_units", new Long(unsignedInt32.longValue()));
        }
        if (hashSet.contains("max_proc_units") && (unsignedInt32 = this._profileBean.getMaxProcUnit()) != null) {
            hashtable.put("max_proc_units", new Long(unsignedInt32.longValue()));
        }
        if (hashSet.contains(IOSLOTS_PROP) && (map = this._profileBean.getIoSlots()) != null) {
            hashtable.put(IOSLOTS_PROP, map);
        }
        if (hashSet.contains(BOOTMODE_PROP) && (unsignedInt8 = this._profileBean.getBootMode()) != null) {
            hashtable.put(BOOTMODE_PROP, new Short(unsignedInt8.shortValue()));
        }
        if (hashSet.contains("conn_monitoring") && (unsignedInt8 = this._profileBean.getSfpSurveillance()) != null) {
            hashtable.put("conn_monitoring", new Short(unsignedInt8.shortValue()));
        }
        if (hashSet.contains("auto_start") && (unsignedInt8 = this._profileBean.getAutoIpl()) != null) {
            hashtable.put("auto_start", new Short(unsignedInt8.shortValue()));
        }
        if (hashSet.contains("power_ctrl_lpar_ids") && (unsignedInt16Array = this._profileBean.getHostingLpars()) != null) {
            hashtable.put("power_ctrl_lpar_ids", unsignedInt16Array);
        }
        if (hashSet.contains("os_type") && (unsignedInt8 = this._profileBean.getOsType()) != null) {
            hashtable.put("os_type", new Short(unsignedInt8.shortValue()));
        }
        if (hashSet.contains("virtual_opti_pool_id") && (unsignedInt8 = this._profileBean.getVirtualOptiConnectPool()) != null) {
            hashtable.put("virtual_opti_pool_id", new Short(unsignedInt8.shortValue()));
        }
        if (hashSet.contains("hsl_pool_id") && (unsignedInt8 = this._profileBean.getHslOptiConnectPool()) != null) {
            hashtable.put("hsl_pool_id", new Short(unsignedInt8.shortValue()));
        }
        if (hashSet.contains("min_5250_cpw_percent") && (unsignedInt16 = this._profileBean.getMinInteractive()) != null) {
            hashtable.put("min_5250_cpw_percent", new Integer(unsignedInt16.intValue()));
        }
        if (hashSet.contains("desired_5250_cpw_percent") && (unsignedInt16 = this._profileBean.getDesiredInteractive()) != null) {
            hashtable.put("desired_5250_cpw_percent", new Integer(unsignedInt16.intValue()));
        }
        if (hashSet.contains("max_5250_cpw_percent") && (unsignedInt16 = this._profileBean.getMaxInteractive()) != null) {
            hashtable.put("max_5250_cpw_percent", new Integer(unsignedInt16.intValue()));
        }
        if (hashSet.contains("sni_config_mode") && (unsignedInt8 = this._profileBean.getSniConfigMode()) != null) {
            hashtable.put("sni_config_mode", new Short(unsignedInt8.shortValue()));
        }
        if (hashSet.contains("sni_device_ids") && (stringArray2 = this._profileBean.getSniDeviceId()) != null) {
            hashtable.put("sni_device_ids", stringArray2);
        }
        if (hashSet.contains("sni_windows") && (unsignedInt16Array = this._profileBean.getSniWindows()) != null) {
            hashtable.put("sni_windows", unsignedInt16Array);
        }
        return hashtable;
    }
}

